<?php $__env->startSection('meta_title', $course?->title . ' || ' . $setting->app_name); ?>
<?php $__env->startPush('custom_meta'); ?>
    <meta property="description" content="<?php echo e($course->seo_description); ?>" />
    <meta property="og:title" content="<?php echo e($course?->title); ?>" />
    <meta property="og:description" content="<?php echo e($course->seo_description); ?>" />
    <meta property="og:image" content="<?php echo e(asset($course->thumbnail)); ?>" />
    <meta property="og:URL" content="<?php echo e(url()->current()); ?>" />
    <meta property="og:type" content="website" />
<?php $__env->stopPush(); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/shareon.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('contents'); ?>
    <!-- breadcrumb-area -->
    <?php if (isset($component)) { $__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c = $attributes; } ?>
<?php $component = App\View\Components\Frontend\Breadcrumb::resolve(['title' => __('Course Details'),'links' => [
        ['url' => route('home'), 'text' => __('Home')],
        ['url' => route('become-instructor'), 'text' => __('Course Details')],
    ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('frontend.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Frontend\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c)): ?>
<?php $attributes = $__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c; ?>
<?php unset($__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c)): ?>
<?php $component = $__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c; ?>
<?php unset($__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c); ?>
<?php endif; ?>
    <!-- breadcrumb-area-end -->

    <!-- courses-details-area -->
    <section class="courses__details-area section-py-120">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <div class="courses__details-thumb">
                        <img class="w-100" src="<?php echo e(asset($course->thumbnail)); ?>" alt="img">
                        <?php if($course->demo_video_source): ?>
                            <a href="<?php echo e($course->demo_video_source); ?>" class="popup-video"
                                aria-label="<?php echo e($course?->title); ?>"><i class="fas fa-play"></i></a>
                        <?php endif; ?>
                    </div>
                    <div class="courses__details-content">
                        <ul class="courses__item-meta list-wrap">
                            <li class="courses__item-tag">
                                <a
                                    href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"><?php echo e($course->category->translation->name); ?></a>
                            </li>
                            <li class="avg-rating"><i class="fas fa-star"></i>
                                <?php echo e(number_format($course->reviews()->avg('rating'), 1) ?? 0); ?> <?php echo e(__('Reviews')); ?></li>
                            <li class="courses__wishlist">
                                <a href="javascript:;" class="wsus-wishlist-btn" aria-label="WishList"
                                    data-slug="<?php echo e($course?->slug); ?>">
                                    <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                </a>
                            </li>
                        </ul>
                        <h2 class="title"><?php echo e($course?->title); ?></h2>
                        <div class="courses__details-meta">
                            <ul class="list-wrap">
                                <li class="author-two">
                                    <img src="<?php echo e(asset($course->instructor->image)); ?>" alt="img"
                                        class="instructor-avatar">
                                    <?php echo e(__('By')); ?>

                                    <a
                                        href="<?php echo e(route('instructor-details', $course->instructor->id)); ?>"><?php echo e($course->instructor->name); ?></a>
                                </li>
                                <li class="date"><i
                                        class="flaticon-calendar"></i><?php echo e(formatDate($course->created_at, 'd/M/Y')); ?></li>
                                <li><i class="flaticon-mortarboard"></i><?php echo e($course->enrollments->count()); ?>

                                    <?php echo e(__('Students')); ?></li>
                            </ul>
                        </div>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="overview-tab" data-bs-toggle="tab"
                                    data-bs-target="#overview-tab-pane" type="button" role="tab"
                                    aria-controls="overview-tab-pane" aria-selected="true"><?php echo e(__('Overview')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="curriculum-tab" data-bs-toggle="tab"
                                    data-bs-target="#curriculum-tab-pane" type="button" role="tab"
                                    aria-controls="curriculum-tab-pane"
                                    aria-selected="false"><?php echo e(__('Curriculum')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="instructors-tab" data-bs-toggle="tab"
                                    data-bs-target="#instructors-tab-pane" type="button" role="tab"
                                    aria-controls="instructors-tab-pane"
                                    aria-selected="false"><?php echo e(__('Instructors')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="reviews-tab" data-bs-toggle="tab"
                                    data-bs-target="#reviews-tab-pane" type="button" role="tab"
                                    aria-controls="reviews-tab-pane" aria-selected="false"><?php echo e(__('reviews')); ?></button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="overview-tab-pane" role="tabpanel"
                                aria-labelledby="overview-tab" tabindex="0">
                                <div class="courses__overview-wrap">
                                    <h3 class="title"><?php echo e(__('Course Description')); ?></h3>
                                    <?php echo clean($course->description); ?>


                                </div>
                            </div>
                            <div class="tab-pane fade" id="curriculum-tab-pane" role="tabpanel"
                                aria-labelledby="curriculum-tab" tabindex="0">
                                <div class="courses__curriculum-wrap">
                                    <h3 class="title"><?php echo e(__('Course Curriculum')); ?></h3>
                                    <p></p>
                                    <div class="accordion" id="accordionExample">
                                        <?php $__currentLoopData = $course->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="heading<?php echo e($chapter->id); ?>">
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#collapse<?php echo e($chapter->id); ?>"
                                                        aria-expanded="false"
                                                        aria-controls="collapse<?php echo e($chapter->id); ?>">
                                                        <?php echo e($loop->iteration); ?>. <?php echo e($chapter?->title); ?>

                                                    </button>
                                                </h2>
                                                <div id="collapse<?php echo e($chapter->id); ?>" class="accordion-collapse collapse"
                                                    aria-labelledby="heading<?php echo e($chapter->id); ?>"
                                                    data-bs-parent="#accordionExample">
                                                    <div class="accordion-body">
                                                        <ul class="list-wrap">
                                                            <?php $__currentLoopData = $chapter->chapterItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapterItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($chapterItem?->type == 'lesson'): ?>
                                                                    <?php if($chapterItem?->lesson?->is_free == 1): ?>
                                                                        <?php if($chapterItem?->lesson?->file_type == 'video'): ?>
                                                                            <?php if($chapterItem?->lesson->storage == 'google_drive'): ?>
                                                                                <li class="course-item open-item">
                                                                                    <a href="javascript:;"
                                                                                        data-bs-toggle="modal"
                                                                                        data-bs-target="#videoModal"
                                                                                        data-bs-video="https://drive.google.com/file/d/<?php echo e(extractGoogleDriveVideoId($chapterItem?->lesson->file_path)); ?>/preview"
                                                                                        class="course-item-link">
                                                                                        <span
                                                                                            class="item-name"><?php echo e($chapterItem?->lesson?->title); ?></span>
                                                                                        <div class="course-item-meta">
                                                                                            <span
                                                                                                class="item-meta duration"><?php echo e(minutesToHours($chapterItem?->lesson?->duration)); ?></span>
                                                                                        </div>
                                                                                    </a>
                                                                                </li>
                                                                            <?php else: ?>
                                                                                <li class="course-item open-item">
                                                                                    <a href="<?php if(!in_array($chapterItem?->lesson->storage, ['wasabi', 'aws'])): ?> <?php echo e($chapterItem?->lesson->file_path); ?> <?php else: ?> <?php echo e(Storage::disk($chapterItem?->lesson->storage)->temporaryUrl($chapterItem?->lesson->file_path, now()->addHours(1))); ?> <?php endif; ?>"
                                                                                        class="course-item-link popup-video">
                                                                                        <span
                                                                                            class="item-name"><?php echo e($chapterItem?->lesson?->title); ?></span>
                                                                                        <div class="course-item-meta">
                                                                                            <span
                                                                                                class="item-meta duration"><?php echo e(minutesToHours($chapterItem?->lesson?->duration)); ?></span>
                                                                                        </div>
                                                                                    </a>
                                                                                </li>
                                                                            <?php endif; ?>
                                                                        <?php else: ?>
                                                                            <li class="course-item">
                                                                                <a href="javascript:;"
                                                                                    class="course-item-link">
                                                                                    <span
                                                                                        class="item-name"><?php echo e($chapterItem?->lesson?->title); ?></span>
                                                                                    <div class="course-item-meta">
                                                                                        <span class="item-meta duration">
                                                                                            --.-- </span>
                                                                                        <span
                                                                                            class="item-meta course-item-status">
                                                                                            <img src="<?php echo e(asset('frontend/img/icons/lock.svg')); ?>"
                                                                                                alt="icon">
                                                                                        </span>
                                                                                    </div>
                                                                                </a>
                                                                            </li>
                                                                        <?php endif; ?>
                                                                    <?php else: ?>
                                                                        <li class="course-item">
                                                                            <a href="javascript:;"
                                                                                class="course-item-link">
                                                                                <span
                                                                                    class="item-name"><?php echo e($chapterItem?->lesson?->title); ?></span>
                                                                                <div class="course-item-meta">
                                                                                    <span
                                                                                        class="item-meta duration"><?php echo e(minutesToHours($chapterItem?->lesson?->duration)); ?></span>
                                                                                    <span
                                                                                        class="item-meta course-item-status">
                                                                                        <img src="<?php echo e(asset('frontend/img/icons/lock.svg')); ?>"
                                                                                            alt="icon">
                                                                                    </span>
                                                                                </div>
                                                                            </a>
                                                                        </li>
                                                                    <?php endif; ?>
                                                                <?php elseif($chapterItem?->type == 'document'): ?>
                                                                    <li class="course-item">
                                                                        <a href="javascript:;" class="course-item-link">
                                                                            <span
                                                                                class="item-name"><?php echo e($chapterItem?->lesson?->title); ?></span>
                                                                            <div class="course-item-meta">
                                                                                <span
                                                                                    class="item-meta duration"><?php echo e(minutesToHours($chapterItem?->lesson?->duration)); ?></span>
                                                                                <span class="item-meta course-item-status">
                                                                                    <img src="<?php echo e(asset('frontend/img/icons/lock.svg')); ?>"
                                                                                        alt="icon">
                                                                                </span>
                                                                            </div>
                                                                        </a>
                                                                    </li>
                                                                <?php elseif($chapterItem->type == 'quiz'): ?>
                                                                    <li class="course-item">
                                                                        <a href="javascript:;" class="course-item-link">
                                                                            <span
                                                                                class="item-name"><?php echo e($chapterItem?->quiz?->title); ?></span>
                                                                            <div class="course-item-meta">
                                                                                <span
                                                                                    class="item-meta duration"><?php echo e(minutesToHours($chapterItem?->lesson?->duration)); ?></span>
                                                                                <span class="item-meta course-item-status">
                                                                                    <img src="<?php echo e(asset('frontend/img/icons/lock.svg')); ?>"
                                                                                        alt="icon">
                                                                                </span>
                                                                            </div>
                                                                        </a>
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="instructors-tab-pane" role="tabpanel"
                                aria-labelledby="instructors-tab" tabindex="0">

                                <div class="courses__instructors-wrap">
                                    <div class="courses__instructors-thumb">
                                        <img src="<?php echo e(asset($course->instructor->image)); ?>" alt="img"
                                            class="instructor-thumb">
                                    </div>
                                    <div class="courses__instructors-content">
                                        <h2 class="title"><?php echo e($course->instructor->name); ?></h2>
                                        <span class="designation"><?php echo e($course->instructor->job_title); ?></span>
                                        <p><?php echo e($course->instructor->short_bio); ?></p>
                                        <div class="instructor__social">
                                            <ul class="list-wrap justify-content-start">
                                                <?php if($course->instructor->facebook): ?>
                                                    <li><a href="<?php echo e($course->instructor->facebook); ?>"
                                                            aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->twitter): ?>
                                                    <li><a href="<?php echo e($course->instructor->twitter); ?>"
                                                            aria-label="Twitter"><i class="fab fa-twitter"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->linkedin): ?>
                                                    <li><a href="<?php echo e($course->instructor->linkedin); ?>"
                                                            aria-label="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->github): ?>
                                                    <li><a href="<?php echo e($course->instructor->github); ?>"
                                                            aria-label="Github"><i class="fab fa-github"></i></a></li>
                                                <?php endif; ?>

                                                <?php if($course->instructor->facebook): ?>
                                                    <li><a href="<?php echo e($course->instructor->facebook); ?>"
                                                            aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->twitter): ?>
                                                    <li><a href="<?php echo e($course->instructor->twitter); ?>"
                                                            aria-label="Twitter"><i class="fab fa-twitter"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->website): ?>
                                                    <li><a href="<?php echo e($course->instructor->website); ?>"
                                                            aria-label="Website"><i class="fas fa-link"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($course->instructor->github): ?>
                                                    <li><a href="<?php echo e($course->instructor->github); ?>"
                                                            aria-label="Github"><i class="fab fa-github"></i></a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <?php if($course->partnerInstructors->count() > 0): ?>
                                    <h3 class="title mt-3"><?php echo e(__('Partner Instructors')); ?></h3>
                                    <?php $__currentLoopData = $course->partnerInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="courses__instructors-wrap">
                                            <div class="courses__instructors-thumb">
                                                <img src="<?php echo e(asset($instructor->instructor->image)); ?>" alt="img">
                                            </div>
                                            <div class="courses__instructors-content">
                                                <h2 class="title"><?php echo e($instructor->instructor->name); ?></h2>
                                                <span class="designation"><?php echo e($instructor->instructor->job_title); ?></span>
                                                <p><?php echo e($instructor->instructor->short_bio); ?></p>
                                                <div class="instructor__social">
                                                    <ul class="list-wrap justify-content-start">
                                                        <?php if($instructor->instructor->facebook): ?>
                                                            <li><a href="<?php echo e($instructor->instructor->facebook); ?>"
                                                                    aria-label="Facebook"><i
                                                                        class="fab fa-facebook-f"></i></a></li>
                                                        <?php endif; ?>
                                                        <?php if($instructor->instructor->twitter): ?>
                                                            <li><a href="<?php echo e($instructor->instructor->twitter); ?>"
                                                                    aria-label="Twitter"><i
                                                                        class="fab fa-twitter"></i></a></li>
                                                        <?php endif; ?>
                                                        <?php if($instructor->instructor->website): ?>
                                                            <li><a href="<?php echo e($instructor->instructor->website); ?>"
                                                                    aria-label="Website"><i class="fas fa-link"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if($instructor->instructor->github): ?>
                                                            <li><a href="<?php echo e($instructor->instructor->github); ?>"
                                                                    aria-label="Github"><i class="fab fa-github"></i></a>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            <div class="tab-pane fade" id="reviews-tab-pane" role="tabpanel"
                                aria-labelledby="reviews-tab" tabindex="0">
                                <div class="courses__rating-wrap">
                                    <h2 class="title"><?php echo e(__('Reviews')); ?></h2>
                                    <div class="course-rate">
                                        <div class="course-rate__summary">
                                            <div class="course-rate__summary-value">
                                                <?php echo e(number_format($course->reviews()->whereHas('course')->whereHas('user')->avg('rating'), 1) ?? 0); ?>

                                            </div>
                                            <div class="course-rate__summary-stars">
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                                <i class="fas fa-star"></i>
                                            </div>
                                            <div class="course-rate__summary-text">
                                                <?php echo e($course->reviews()->whereHas('course')->whereHas('user')->where('status', 1)->count()); ?>

                                                <?php echo e(__('Ratings')); ?>

                                            </div>
                                        </div>
                                        <?php
                                            $totalRating = $course->reviews_count;
                                            $fiveStar = $course
                                                ->reviews()
                                                ->where('rating', 5)
                                                ->where('status', 1)
                                                ->whereHas('course')
                                                ->whereHas('user')
                                                ->count();
                                            $fourStar = $course
                                                ->reviews()
                                                ->where('rating', 4)
                                                ->where('status', 1)
                                                ->whereHas('course')
                                                ->whereHas('user')
                                                ->count();
                                            $threeStar = $course
                                                ->reviews()
                                                ->where('rating', 3)
                                                ->where('status', 1)
                                                ->whereHas('course')
                                                ->whereHas('user')
                                                ->count();
                                            $twoStar = $course
                                                ->reviews()
                                                ->where('rating', 2)
                                                ->where('status', 1)
                                                ->whereHas('course')
                                                ->whereHas('user')
                                                ->count();
                                            $oneStar = $course
                                                ->reviews()
                                                ->where('rating', 1)
                                                ->where('status', 1)
                                                ->whereHas('course')
                                                ->whereHas('user')
                                                ->count();
                                            $totalPercentage = $totalRating > 0 ? ($fiveStar / $totalRating) * 100 : 0;
                                            $fourPercentage = $totalRating > 0 ? ($fourStar / $totalRating) * 100 : 0;
                                            $threePercentage = $totalRating > 0 ? ($threeStar / $totalRating) * 100 : 0;
                                            $twoPercentage = $totalRating > 0 ? ($twoStar / $totalRating) * 100 : 0;
                                            $onePercentage = $totalRating > 0 ? ($oneStar / $totalRating) * 100 : 0;
                                        ?>
                                        <div class="course-rate__details">
                                            <div class="course-rate__details-row">
                                                <div class="course-rate__details-row-star">
                                                    5
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="course-rate__details-row-value">
                                                    <div class="rating-gray"></div>
                                                    <div class="rating" style="width: <?php echo e($totalPercentage); ?>%;"
                                                        title="<?php echo e($totalPercentage); ?>%"></div>
                                                    <span class="rating-count"><?php echo e($fiveStar); ?></span>
                                                </div>
                                            </div>
                                            <div class="course-rate__details-row">
                                                <div class="course-rate__details-row-star">
                                                    4
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="course-rate__details-row-value">
                                                    <div class="rating-gray"></div>
                                                    <div class="rating" style="width: <?php echo e($fourPercentage); ?>%;"
                                                        title="<?php echo e($fourPercentage); ?>%"></div>
                                                    <span class="rating-count"><?php echo e($fourStar); ?></span>
                                                </div>
                                            </div>
                                            <div class="course-rate__details-row">
                                                <div class="course-rate__details-row-star">
                                                    3
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="course-rate__details-row-value">
                                                    <div class="rating-gray"></div>
                                                    <div class="rating" style="width: <?php echo e($threePercentage); ?>%;"
                                                        title="<?php echo e($threePercentage); ?>%"></div>
                                                    <span class="rating-count"><?php echo e($threeStar); ?></span>
                                                </div>
                                            </div>
                                            <div class="course-rate__details-row">
                                                <div class="course-rate__details-row-star">
                                                    2
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="course-rate__details-row-value">
                                                    <div class="rating-gray"></div>
                                                    <div class="rating" style="width: <?php echo e($twoPercentage); ?>%;"
                                                        title="<?php echo e($twoPercentage); ?>%"></div>
                                                    <span class="rating-count"><?php echo e($twoStar); ?></span>
                                                </div>
                                            </div>
                                            <div class="course-rate__details-row">
                                                <div class="course-rate__details-row-star">
                                                    1
                                                    <i class="fas fa-star"></i>
                                                </div>
                                                <div class="course-rate__details-row-value">
                                                    <div class="rating-gray"></div>
                                                    <div class="rating" style="width: <?php echo e($onePercentage); ?>%;"
                                                        title="<?php echo e($onePercentage); ?>%"></div>
                                                    <span class="rating-count"><?php echo e($oneStar); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="course-review-head">
                                            <div class="review-author-thumb">
                                                <img src="<?php echo e(asset($review?->user?->image)); ?>" alt="img">
                                            </div>
                                            <div class="review-author-content">
                                                <div class="author-name">
                                                    <h5 class="name"><?php echo e($review?->user?->name); ?>

                                                        <span><?php echo e(formatDate($review->created_at)); ?></span>
                                                    </h5>
                                                    <div class="author-rating">
                                                        <?php for($i = 1; $i <= $review->rating; $i++): ?>
                                                            <i class="fas fa-star"></i>
                                                        <?php endfor; ?>
                                                    </div>
                                                </div>
                                                <p><?php echo e($review->review); ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="courses__details-sidebar">
                        <div class="courses__cost-wrap">
                            <span><?php echo e(__('This Course Fee')); ?>:</span>
                            <?php if($course->price == 0): ?>
                                <h2 class="title"><?php echo e(__('Free')); ?></h2>
                            <?php elseif($course->discount): ?>
                                <h2 class="title"><?php echo e(currency($course->discount)); ?>

                                    <del><?php echo e(currency($course->price)); ?></del>
                                </h2>
                            <?php else: ?>
                                <h2 class="title"><?php echo e(currency($course->price)); ?></h2>
                            <?php endif; ?>

                        </div>
                        <div class="courses__information-wrap">
                            <h5 class="title"><?php echo e(__('Course includes')); ?>:</h5>
                            <ul class="list-wrap">
                                <li class="level-wrapper">
                                    <b>
                                        <img src="<?php echo e(asset('frontend/img/icons/course_icon01.svg')); ?>" alt="img"
                                            class="injectable">
                                        <?php echo e(__('Level')); ?>

                                    </b>
                                    <ul class="course-level-list">
                                        <?php $__currentLoopData = $course->levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="level"><?php echo e(@$level->level->translation->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                <li>
                                    <img src="<?php echo e(asset('frontend/img/icons/course_icon02.svg')); ?>" alt="img"
                                        class="injectable">
                                    <?php echo e(__('Duration')); ?>

                                    <span><?php echo e(minutesToHours($course->duration)); ?></span>
                                </li>
                                <li>
                                    <img src="<?php echo e(asset('frontend/img/icons/course_icon03.svg')); ?>" alt="img"
                                        class="injectable">
                                    <?php echo e(__('Lessons')); ?>

                                    <span><?php echo e($courseLessonCount); ?></span>
                                </li>
                                <li>
                                    <img src="<?php echo e(asset('frontend/img/icons/course_icon04.svg')); ?>" alt="img"
                                        class="injectable">
                                    <?php echo e(__('Quizzes')); ?>

                                    <span><?php echo e($courseQuizCount); ?></span>
                                </li>
                                <li>
                                    <img src="<?php echo e(asset('frontend/img/icons/course_icon05.svg')); ?>" alt="img"
                                        class="injectable">
                                    <?php echo e(__('Certifications')); ?>

                                    <?php if($course->certificate): ?>
                                        <span><?php echo e(__('Yes')); ?></span>
                                    <?php else: ?>
                                        <span><?php echo e(__('No')); ?></span>
                                    <?php endif; ?>
                                </li>
                                <li class="level-wrapper">
                                    <b>
                                        <img src="<?php echo e(asset('frontend/img/icons/course_icon06.svg')); ?>" alt="img"
                                            class="injectable">
                                        <?php echo e(__('Language')); ?>

                                    </b>

                                    <ul class="course-language-list">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e($language->language->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                        <div class="courses__details-social">
                            <h5 class="title"><?php echo e(__('Share this course')); ?>:</h5>
                            <div class="shareon">
                                <a class="facebook"></a>
                                <a class="linkedin"></a>
                                <a class="pinterest"></a>
                                <a class="telegram"></a>
                                <a class="twitter"></a>
                            </div>
                        </div>
                        <div class="courses__details-enroll">
                            <div class="tg-button-wrap">
                                <?php if(in_array($course->id, session('enrollments') ?? [])): ?>
                                    <a href="<?php echo e(route('student.enrolled-courses')); ?>"
                                        class="btn btn-two arrow-btn already-enrolled-btn" data-id="">
                                        <span class="text"><?php echo e(__('Enrolled')); ?></span>
                                        <i class="flaticon-arrow-right"></i>
                                    </a>
                                <?php elseif($course->enrollments->count() >= $course->capacity && $course->capacity != null): ?>
                                    <a href="javascript:;" class="btn btn-two arrow-btn" data-id="<?php echo e($course->id); ?>">
                                        <span class="text"><?php echo e(__('Booked')); ?></span>
                                        <i class="flaticon-arrow-right"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="javascript:;" class="btn btn-two arrow-btn add-to-cart"
                                        data-id="<?php echo e($course->id); ?>">
                                        <span class="text"><?php echo e(__('Add To Cart')); ?></span>
                                        <i class="flaticon-arrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <?php if(Module::has('GiftCourse') && Module::isEnabled('GiftCourse')): ?>
                                <div class="d-block text-center mt-3">
                                    <a href="<?php echo e(route('gift-course', $course->slug)); ?>" class="btn btn-four arrow-btn">
                                        <i class="fas fa-gift"></i> <?php echo e(__('Gift This Course')); ?>

                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Google Drive player modal Structure -->
    <div class="google_drive_modal">
        <div class="modal fade" id="videoModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i
                                class="fas fa-times"></i></button>
                    </div>
                    <div class="modal-body">
                        <div class="ratio ratio-16x9">
                            <iframe class="iframe-video" src="" width="640" height="680" allow="autoplay"
                                frameborder="0" allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- courses-details-area-end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/course-details.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/shareon.iife.js')); ?>"></script>
    <script>
        Shareon.init();
    </script>

    <?php if($setting->google_tagmanager_status == 'active' && $marketing_setting?->course_details): ?>
        <script>
            $(document).ready(function() {
                dataLayer.push({
                    'event': 'courseDetails',
                    'courses': {
                        'name': '<?php echo e($course?->title); ?>',
                        'price': '<?php echo e(currency($course->price)); ?>',
                        'instructor': '<?php echo e($course->instructor->name); ?>',
                        'category': '<?php echo e($course->category->translation->name); ?>',
                        'lessons': '<?php echo e($courseLessonCount); ?>',
                        'duration': '<?php echo e(minutesToHours($course->duration)); ?>',
                        'url': "<?php echo e(route('course.show', $course->slug)); ?>",
                    }
                });
            });
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmfollows/skillgrow.kenyapanel.com/resources/views/frontend/pages/course-details.blade.php ENDPATH**/ ?>