<?php $__env->startSection('meta_title', $blog->translation->title . ' || ' . $setting->app_name); ?>

<?php $__env->startPush('custom_meta'); ?>
    <meta name="description" content="<?php echo e($blog->translation->seo_description); ?>">
    <meta property="keywords" content="<?php echo e(getTags(json_decode($blog->tags))); ?>" />
    <meta property="og:title" content="<?php echo e($blog->translation->seo_title); ?>" />
    <meta property="og:description" content="<?php echo e($blog->translation->seo_description); ?>" />
    <meta property="og:image" content="<?php echo e(asset($blog->image)); ?>" />
    <meta property="og:URL" content="<?php echo e(url()->current()); ?>" />
    <meta property="og:type" content="website" />
<?php $__env->stopPush(); ?>
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/shareon.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('meta_title', $setting->app_name . ' | ' . $blog->title); ?>
<?php $__env->startSection('contents'); ?>
    <!-- breadcrumb-area -->
    <?php if (isset($component)) { $__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c = $attributes; } ?>
<?php $component = App\View\Components\Frontend\Breadcrumb::resolve(['title' => __('Blog Details'),'links' => [
        ['url' => route('home'), 'text' => __('Home')],
        ['url' => route('blogs'), 'text' => __('Blogs')],
        ['url' => '', 'text' => $blog->title],
    ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('frontend.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Frontend\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c)): ?>
<?php $attributes = $__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c; ?>
<?php unset($__attributesOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c)): ?>
<?php $component = $__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c; ?>
<?php unset($__componentOriginalcc52fffb9c918b8f3f4cf5faa6f3a53c); ?>
<?php endif; ?>
    <!-- breadcrumb-area-end -->

    <!-- blog-details-area -->
    <section class="blog-details-area section-py-120">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <div class="blog__details-wrapper">
                        <div class="blog__details-thumb">
                            <img src="<?php echo e(asset($blog->image)); ?>" alt="img">
                        </div>
                        <div class="blog__details-content">
                            <div class="blog__post-meta">
                                <ul class="list-wrap">
                                    <li><i class="flaticon-calendar"></i> <?php echo e(formatDate($blog->created_at)); ?></li>
                                    <li><i class="flaticon-user-1"></i> <?php echo e(__('by')); ?> <a
                                            href="javascript:;"><?php echo e($blog->author->name); ?></a></li>
                                    <li><i class="flaticon-clock"></i>
                                        <?php echo e(calculateReadingTime($blog->translation->description)); ?> <?php echo e(__('Min Read')); ?>

                                    </li>
                                    <li><i class="far fa-comment-alt"></i> <?php echo e(count($comments)); ?> <?php echo e(__('Comments')); ?>

                                    </li>
                                </ul>
                            </div>
                            <h3 class="title"><?php echo e($blog->translation->title); ?></h3>
                            <p>
                                <?php echo clean($blog->translation->description); ?>

                            </p>
                            <div class="blog__details-bottom">
                                <div class="row">
                                    <div class="col-xl-6 col-md-7">
                                        <div class="tg-post-tag">
                                            <?php if($blog->tags): ?>
                                            <h5 class="tag-title"><?php echo e(__('Tags ')); ?>:</h5>
                                            <ul class="list-wrap p-0 mb-0">
                                                <?php $__currentLoopData = json_decode($blog->tags) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a href="javascript:;"><?php echo e($tag->value); ?></a></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-md-5">
                                        <div class="tg-post-social justify-content-start justify-content-md-end">
                                            <h5 class="social-title"><?php echo e(__('Share')); ?> :</h5>
                                            <ul class="list-wrap p-0 mb-0">
                                                <div class="shareon">
                                                    <a class="facebook"></a>
                                                    <a class="linkedin"></a>
                                                    <a class="pinterest"></a>
                                                    <a class="telegram"></a>
                                                    <a class="twitter"></a>
                                                </div>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="blog__post-author">
                        <div class="blog__post-author-thumb">
                            <a href="#"><img src="<?php echo e(asset($blog->author->image)); ?>" alt="img"></a>
                        </div>
                        <div class="blog__post-author-content">
                            <span class="designation"><?php echo e(__('Author')); ?></span>
                            <h5 class="name"><?php echo e($blog->author->name); ?></h5>
                            <p><?php echo e($blog->author->bio); ?></p>
                        </div>
                    </div>
                    <div class="blog-post-comment">
                        <div class="comment-wrap">
                            <?php if(count($comments) > 0): ?>
                            <div class="comment-wrap-title">
                                <h4 class="title"><?php echo e(count($comments)); ?> <?php echo e(__('Comments')); ?></h4>
                            </div>
                            <?php endif; ?>
                            <div class="latest-comments">
                                <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <ul class="list-wrap">
                                        <li>
                                            <div class="comments-box">
                                                <div class="comments-avatar">
                                                    <img src="<?php echo e(asset($comment->user->image)); ?>" alt="img">
                                                </div>
                                                <div class="comments-text">
                                                    <div class="avatar-name">
                                                        <h6 class="name"><?php echo e($comment->user->name); ?></h6>
                                                        <span class="date"><?php echo e(formatDate($comment->created_at)); ?></span>
                                                    </div>
                                                    <p><?php echo e($comment->comment); ?></p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                    <hr class="col-12 border">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php if(auth()->guard()->check()): ?>
                            <div class="comment-respond">
                                <h4 class="comment-reply-title"><?php echo e(__('Post a comment')); ?></h4>
                                <div class="comment-note">
                                    <p><?php echo e(__('Please keep your comment under 1000 characters')); ?></p>
                                </div>
                                <form action="<?php echo e(route('blog.submit-comment')); ?>" class="comment-form" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="blog_id" value="<?php echo e($blog->id); ?>">
                                    <div class="comment-field">
                                        <textarea placeholder="<?php echo e(__('Comment')); ?>" name="comment"></textarea>
                                    </div>
                                    <!-- g-recaptcha -->
                                    <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
                                        <div class="form-grp mt-3">
                                            <div class="g-recaptcha"
                                                data-sitekey="<?php echo e(Cache::get('setting')->recaptcha_site_key); ?>"></div>
                                        </div>
                                    <?php endif; ?>

                                    <p class="form-submit"></p>
                                    <button class="btn btn-two arrow-btn"><?php echo e(__('Post Comment')); ?> <img
                                            src="<?php echo e(asset('frontend/img/icons/right_arrow.svg')); ?>" alt="img"
                                            class="injectable"></button>
                                </form>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-primary d-flex align-items-center" role="alert">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                                    class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16"
                                    role="img" aria-label="Warning:">
                                    <path
                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </svg>
                                <div>
                                    <?php echo e(__('Please login to comment')); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
                <div class="col-xl-3 col-lg-4">
                    <aside class="blog-sidebar">
                        <div class="blog-widget widget_search">
                            <div class="sidebar-search-form">
                                <form action="<?php echo e(route('blogs')); ?>" method="get">
                                    <input type="text" placeholder="<?php echo e(__('Search here')); ?>" name="search">
                                    <button type="submit"><i class="flaticon-search"></i></button>
                                </form>
                            </div>
                        </div>
                        <div class="blog-widget">
                            <h4 class="widget-title"><?php echo e(__('Categories')); ?></h4>
                            <div class="shop-cat-list">
                                <ul class="list-wrap">
                                    <?php $__currentLoopData = $categories->sortBy('translation.title'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('blogs', ['category' => $category->slug])); ?>"><i
                                                    class="flaticon-angle-right"></i><?php echo e($category->translation->title); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </div>
                        </div>
                        <div class="blog-widget">
                            <h4 class="widget-title"><?php echo e(__('Latest Post')); ?></h4>
                            <?php $__empty_1 = true; $__currentLoopData = $latestBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="rc-post-item">
                                    <div class="rc-post-thumb">
                                        <a href="<?php echo e(route('blog.show', $blog->slug)); ?>">
                                            <img class="h_60px" src="<?php echo e(asset($blog->image)); ?>" alt="img">
                                        </a>
                                    </div>
                                    <div class="rc-post-content">
                                        <span class="date"><i class="flaticon-calendar"></i>
                                            <?php echo e(formatDate($blog->created_at)); ?></span>
                                        <h4 class="title"><a
                                                href="<?php echo e(route('blog.show', $blog->slug)); ?>"><?php echo e(truncate($blog->translation->title, 30)); ?></a>
                                        </h4>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p><?php echo e(__('No latest post yet')); ?>.</p>
                            <?php endif; ?>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <!-- blog-details-area-end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/shareon.iife.js')); ?>"></script>

    <script>
        Shareon.init();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmfollows/skillgrow.kenyapanel.com/resources/views/frontend/pages/blog-details.blade.php ENDPATH**/ ?>