<?php $__empty_1 = true; $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="col-xxl-4 col-md-6 col-lg-6 col-xl-6">
        <div class="courses__item shine__animate-item">
            <div class="courses__item-thumb">
                <a href="<?php echo e(route('course.show', $course->slug)); ?>" class="shine__animate-link">
                    <img src="<?php echo e(asset($course->thumbnail)); ?>" alt="img">
                </a>
                <a href="javascript:;" class="wsus-wishlist-btn common-white courses__wishlist-two"
                    data-slug="<?php echo e($course?->slug); ?>" aria-label="WishList">
                    <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                </a>
            </div>
            <div class="courses__item-content">
                <ul class="courses__item-meta list-wrap">
                    <li class="courses__item-tag">
                        <a
                            href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"><?php echo e($course->category->translation->name); ?></a>
                    </li>
                    <li class="avg-rating"><i class="fas fa-star"></i>
                        <?php echo e(number_format($course->reviews()->avg('rating'), 1) ?? 0); ?></li>
                </ul>
                <h5 class="title"><a
                        href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e(truncate($course->title, 50)); ?></a></h5>
                <p class="author"><?php echo e(__('By')); ?> <a
                        href="<?php echo e(route('instructor-details', ['id' => $course->instructor->id, 'slug' => Str::slug($course->instructor->name)])); ?>"><?php echo e($course->instructor->name); ?></a>
                </p>
                <div class="courses__item-bottom">
                    <?php if(in_array($course->id, session('enrollments') ?? [])): ?>
                        <div class="button">
                            <a href="<?php echo e(route('student.enrolled-courses')); ?>" class="already-enrolled-btn"
                                data-id="">
                                <span class="text"><?php echo e(__('Enrolled')); ?></span>
                                <i class="flaticon-arrow-right"></i>
                            </a>
                        </div>
                    <?php elseif($course->enrollments->count() >= $course->capacity && $course->capacity != null): ?>
                        <div class="button">
                            <a href="javascript:;" class="" data-id="<?php echo e($course->id); ?>">
                                <span class="text"><?php echo e(__('Booked')); ?></span>
                                <i class="flaticon-arrow-right"></i>
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="button">
                            <a href="javascript:;" class="add-to-cart" data-id="<?php echo e($course->id); ?>">
                                <span class="text"><?php echo e(__('Add To Cart')); ?></span>
                                <i class="flaticon-arrow-right"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php if($course->price == 0): ?>
                        <h5 class="price"><?php echo e(__('Free')); ?></h5>
                    <?php elseif($course->price > 0 && $course->discount > 0): ?>
                        <h5 class="price"><?php echo e(currency($course->discount)); ?></h5>
                    <?php else: ?>
                        <h5 class="price"><?php echo e(currency($course->price)); ?></h5>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="w-100">
        <h6 class="text-center"><?php echo e(__('No Course Found!')); ?></h6>
    </div>
<?php endif; ?>
<?php /**PATH /home/mmfollows/skillgrow.kenyapanel.com/resources/views/frontend/partials/course-card.blade.php ENDPATH**/ ?>