<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class SetLocaleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // if there is no session set, then set the default locale
        if (!Session::has('lang')) {
            Session::put('lang', getDefaultLanguage());
            App::setlocale(Session::get('lang'));
        }else{
            App::setlocale(Session::get('lang'));
        }

        return $next($request);
    }
}
